%------------------------------------------------------------------------------
% File     : DRA2 : TPTP v0.0.0. Released v0.0.0.
% Domain   : Algebra
% Axioms   : Basic conjectures for Demonic Refinement Algebra
% Version  :
% English  :

% Refs     :
% Source   :
% Names    :

% Status   : unknown
% Rating   : ?
% Syntax   : Number of formulae    :   22 (  18 unit)
%            Number of atoms       :   28 (  13 equality)
%            Maximal formula depth :    6 (   2 average)
%            Number of connectives :    6 (   0   ~;   0   |;   2   &)
%                                         (   1 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    5 (   2 constant; 0-2 arity)
%            Number of variables   :   24 (   0 singleton;  24 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)

% Comments : Most of them are easy to prove
%          : Requires TBA
%------------------------------------------------------------------------------
include('/home/graph/tptp/tmp/HofnerKleeneALG/Axioms/DRA.ax').
%------------------------------------------------------------------------------
%----Order properties
fof(reflexivity,conjecture,(
    ! [A] : 
      ( leq(A,A) ) )).

fof(transitivity,conjecture,(
    ! [X15,X16,X17] : 
      ( ( leq(X15,X16)
        & leq(X16,X17) )
     => leq(X15,X17) ) )).

%----Splitting equations into two inequations
fof(split_eq,conjecture,(
    ! [A,B] :
      ( A = B
    <=> ( leq(A,B)
        & leq(B,A) ) ) )).

%----Star properties
fof(star_superidentity,conjecture,(
    ! [A] : leq(one,star(A)) )).

fof(star_closure1,conjecture,(
    ! [A] : leq(A,star(A)) )).

fof(star_closure2,conjecture,(
    ! [A] : star(star(A)) = star(A) )).

fof(star_closure3,conjecture,(
    ! [A] : mul(star(A),star(A)) = star(A) )).

fof(semi_star_unfold,conjecture,(
    ! [A] : leq(mul(A,star(A)),star(A)) )).

fof(short_induction1,conjecture,(
    ! [A,B] :
      ( leq(mul(A,B),B)
     => leq(mul(star(A),B),B) ) )).

fof(short_induction2,conjecture,(
    ! [A,B] :
      ( leq(mul(B,A),B)
     => leq(mul(B,star(A)),B) ) )).

fof(star_of_zero,conjecture,(
    star(zero) = one )).

fof(star_of_one,conjecture,(
    star(one) = one )).

%----Properties concerning strong iteration
fof(max_element1,conjecture,(
    ! [A] : leq(A,infty(one)) )).

fof(infty_left_ann,conjecture,(
    ! [A] : mul(infty(one),A) = infty(one) )).

fof(max_element2,conjecture,(
    ! [A] : infty(infty(A)) = infty(one) )).

fof(max_element3,conjecture,(
    ! [A] : infty(star(A)) = infty(one) )).

fof(infty_of_zero,conjecture,(
    infty(zero) = one )).

fof(infty_closure1,conjecture,(
    ! [A] : mul(infty(A),infty(A)) = infty(A) )).

fof(infty_superidentity,conjecture,(
    ! [A] : leq(one,infty(A)) )).

fof(infty_closure2,conjecture,(
    ! [A] : star(infty(A)) = infty(A) )).

fof(infty_closure3,conjecture,(
    ! [A] : mul(star(A),infty(A)) = infty(A) )).

fof(infty_unfold_conjecture1,lemma,(
    ! [A] : mul(infty(A),star(A)) = infty(A) )).

fof(invCR,conjecture,(
    ! [A,B] : leq(mul(infty(A),infty(B)),infty(add(A,B))) )).

%------------------------------------------------------------------------------
