%------------------------------------------------------------------------------
% File     : DRA1 : TPTP v0.0.0. Released v0.0.0.
% Domain   : Algebra
% Axioms   : Basic conjectures for Demonic Refinement Algebra
% Version  :
% English  :

% Refs     :
% Source   :
% Names    :

% Status   : unknown
% Rating   : ?
% Syntax   : Number of formulae    :    9 (   2 unit)
%            Number of atoms       :   17 (   2 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    8 (   0   ~;   0   |;   1   &)
%                                         (   1 <=>;   6  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    6 (   2 constant; 0-2 arity)
%            Number of variables   :   21 (   0 singleton;  21 !;   0 ?)
%            Maximal term depth    :    4 (   1 average)
      
% Comments : These are needed quite often when proving theorems in DRA
%          : Requires TBA
%------------------------------------------------------------------------------
include('/home/graph/tptp/tmp/HofnerKleeneALG/Axioms/DRA.ax').
%------------------------------------------------------------------------------
%----Zero neutral element from the left
fof(additive_identity2,conjecture,(
    ! [A] : add(zero,A) = A )).

%----Second unfold law for strong iteration
fof(infty_unfold2,conjecture,(
    ! [A] : infty(A) = add(mul(infty(A),A),one) )).

%----Isotonicity w.r.t. add
fof(isotonicity_addition1,conjecture,(
    ! [A,B,C] : 
      ( leq(A,B)
     => leq(add(A,C),add(B,C)) ) )).

fof(isotonicity_addition2,conjecture,(
    ! [A,B,C] :
      ( leq(A,B)
     => leq(add(C,A),add(C,B)) ) )).

%----Isotonicity w.r.t. mul
fof(isotonicity_multiplication1,conjecture,(
    ! [A,B,C] :
      ( leq(A,B)
     => leq(mul(A,C),mul(B,C)) ) )).

fof(isotonicity_multiplication2,conjecture,(
    ! [A,B,C] : 
      ( leq(A,B)
     => leq(mul(C,A),mul(C,B)) ) )).

%----Isotonicity w.r.t. star
fof(star_isotonicity,conjecture,(
    ! [A,B] : 
      ( leq(A,B)
     => leq(star(A),star(B)) ) )).

%----Isotonicity w.r.t. infty
fof(infty_isotonicity,conjecture,(
    ! [A,B] : 
      ( leq(A,B)
     => leq(infty(A),infty(B)) ) )).

%----Join splitting
fof(join_splitting,conjecture,(
    ! [A,B,C] : 
      ( leq(add(A,B),C)
    <=> ( leq(A,C)
        & leq(B,C) ) ) )).
%------------------------------------------------------------------------------
